--[[
Make cow milking be done twice a day.

Author:     Reddog
Version:    1.0.0
Modified:   2023-05-02

Changelog:

]]


RDM_RealisticMilkingTime = Mod:init()
RDM_RealisticMilkingTime.MilkingHours = {6, 18}

PlaceableHusbandry.addHusbandryFillLevelFromTool = Utils.overwrittenFunction(PlaceableHusbandry.addHusbandryFillLevelFromTool, function (self, superfunc, farmId, deltaFillLevel, fillTypeIndex, fillPositionData, toolType, extraAttributes)
	local spec = self.spec_husbandry
	if spec.unloadingStation == nil then
		return 0
	end
	if fillTypeIndex == FillType.MILK and deltaFillLevel>0 then
		if spec.RDM_RealisticMilkingTimeFillLevel==nil then
			spec.RDM_RealisticMilkingTimeFillLevel = 0
		end
		local newFillLevel = spec.RDM_RealisticMilkingTimeFillLevel + deltaFillLevel	
		local hour = g_currentMission.environment.currentHour
		local matched = false
		for _,hr in pairs(RDM_RealisticMilkingTime.MilkingHours) do
			if hr == hour then	
				matched = true
			end
		end	
		if matched then
			spec.RDM_RealisticMilkingTimeFillLevel = 0
			return spec.unloadingStation:addFillLevelFromTool(farmId or self:getOwnerFarmId(), newFillLevel, fillTypeIndex, fillPositionData, toolType, extraAttributes)
		else
			spec.RDM_RealisticMilkingTimeFillLevel = newFillLevel
			return 0
		end
	else
		return spec.unloadingStation:addFillLevelFromTool(farmId or self:getOwnerFarmId(), deltaFillLevel, fillTypeIndex, fillPositionData, toolType, extraAttributes)
	end
end
)
function RDM_RealisticMilkingTime:beforeLoadMap()
	local schemaSavegame = Placeable.xmlSchemaSavegame
	local key = "placeables.placeable(?).husbandry"
	schemaSavegame:register(XMLValueType.FLOAT, key.."#RDM_RealisticMilkingTimeFillLevel", "Milk Level Accrued", 0)
end
PlaceableHusbandry.saveToXMLFile = Utils.appendedFunction(PlaceableHusbandry.saveToXMLFile, function(self, xmlFile, key, usedModNames)
	local spec = self.spec_husbandry
		if spec.RDM_RealisticMilkingTimeFillLevel~=nil then
			xmlFile:setValue(key .. "#RDM_RealisticMilkingTimeFillLevel", spec.RDM_RealisticMilkingTimeFillLevel)
		end
	end
	)
PlaceableHusbandry.loadFromXMLFile = Utils.appendedFunction(PlaceableHusbandry.loadFromXMLFile, function(self, xmlFile, key)
	local spec = self.spec_husbandry
			spec.RDM_RealisticMilkingTimeFillLevel = xmlFile:getValue(key .. "#RDM_RealisticMilkingTimeFillLevel", 0)
	end
	)