FruitCollectChangeSettingsEvent = {};
FruitCollectChangeSettingsEvent_mt = Class(FruitCollectChangeSettingsEvent, Event);
InitEventClass(FruitCollectChangeSettingsEvent, "FruitCollectChangeSettingsEvent");

FruitCollectChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
FruitCollectChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function FruitCollectChangeSettingsEvent.emptyNew()
    local self = Event.new(FruitCollectChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function FruitCollectChangeSettingsEvent.new(settingsId, settingsState)
    local self = FruitCollectChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function FruitCollectChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, FruitCollectChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, FruitCollectChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function FruitCollectChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, FruitCollectChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, FruitCollectChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function FruitCollectChangeSettingsEvent:run(connection)		
	if self.settingsId == "fruitCollectMission_minMax" then
		g_additionalContractTypes:getTyp("fruitCollectMission"):setMaxNumInstance(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

