AdditionalContracts = {};
AdditionalContracts.modDir = g_currentModDirectory;
AdditionalContracts.modName = g_currentModName;
AdditionalContracts.otherMods = {autoload=false,rollerMission=false};
AdditionalContracts.values = {isInitUISetting=false,isFirstRun=false};
AdditionalContracts.testString = {};

AdditionalContracts.metadata = {
	interface = "FS25 ...", --new
	title = "Additional Contracts",
	notes = "Dieser Mod generiert Aufträge für verschiedene Bereiche\Branchen – beispielsweise Walzen,Häckseln,Mulchen und mehr.",
	author = "(by HappyLooser)",
	version = "1.0.0.5",	
	build = 20,
	xmlVersion = 1,
	datum = "10.07.2025",
	update = "14.01.2026",
	debugPrint = false, 
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe: https://www.farming-simulator.com/mods.php"
};

source(AdditionalContracts.modDir.. "gui/UIGameSettings.lua");
source(AdditionalContracts.modDir.. "gui/UIHelperGameSettings.lua");
source(AdditionalContracts.modDir.. "missions/mapHotspots/UniversalCircleMissionHotspot.lua");
source(AdditionalContracts.modDir.. "missions/mapHotspots/UniversalMissionHotspot.lua");
source(AdditionalContracts.modDir.. "manager/AdditionalContractUtils.lua");
source(AdditionalContracts.modDir.. "manager/AdditionalContractTypes.lua");
source(AdditionalContracts.modDir.. "manager/AdditionalContractMapData.lua");
source(AdditionalContracts.modDir.. "manager/AdditionalContractLoading.lua");

function AdditionalContracts:loadMap(name)
	print("---loading ".. tostring(AdditionalContracts.metadata.title).. " ".. tostring(AdditionalContracts.metadata.version).. "(#".. tostring(AdditionalContracts.metadata.build).. ") ".. tostring(AdditionalContracts.metadata.author).. "---")	
	AdditionalContracts:searchOtherMods();	
	InGameMenu.onMenuOpened = Utils.appendedFunction(InGameMenu.onMenuOpened, AdditionalContracts.initUISetting);	
    FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, AdditionalContracts.saveSettingsXML);
	Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, AdditionalContracts.onStartMission);
	FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, AdditionalContracts.loadSettingsFromServer);
	g_additionalContractTypes:loadMap();
	g_additionalContractMapData:loadMap();
end;

function AdditionalContracts:onStartMission()
	local detiServer = AdditionalContracts:getDetiServer();
	if not detiServer then
		g_currentMission.hlUtils.modLoad("FS25_AdditionalContracts");
		g_currentMission.hlUtils.loadFillTypesOverlays(); --needs for mapHotspots transport,deliver contracts
		AdditionalContracts.values.isFirstRun = true;
		AdditionalContracts:createIcons();				
	end;	
	g_additionalContractTypes:onStartMap( {isDetiServer=detiServer} );
	g_additionalContractMapData:onStartMap( {isDetiServer=detiServer} );
end;

function AdditionalContracts:update(dt)
	if AdditionalContracts.values.isFirstRun then
		AdditionalContracts.values.isFirstRun = false;
		AdditionalContracts:isOnStartMap();		
	end;
	g_additionalContractTypes:update(dt);
	g_additionalContractMapData:update(dt);
end;

function AdditionalContracts:draw()
	if AdditionalContracts:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	--respect settings for other mods (not every mod) that's why
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods	
			
	if #AdditionalContracts.testString > 0 then
		setTextBold(true);		
		for a=1, #AdditionalContracts.testString do
			local posY = 0.25-(a/100);
			renderText(0.5, posY, 0.010, "-S ".. tostring(a).. "- ".. tostring(AdditionalContracts.testString[a]));
		end;
	end;
		
	--respect settings for other mods
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
end;

function AdditionalContracts:isOnStartMap()
	local detiServer = AdditionalContracts:getDetiServer();
	if not detiServer then AdditionalContracts:createHlSystemValues();end;
	g_additionalContractTypes:isOnStartMap( {isDetiServer=detiServer} );
	g_additionalContractMapData:isOnStartMap( {isDetiServer=detiServer} );
end;

function AdditionalContracts.saveSettingsXML()
	g_additionalContractTypes:saveSettingsXML(g_currentMission);
end;

function AdditionalContracts.loadSettingsFromServer(mission, connection, x, y, z, viewDistanceCoeff)
	g_additionalContractTypes:loadSettingsFromServer(mission, connection, x, y, z, viewDistanceCoeff);
end;
addModEventListener(AdditionalContracts);
 
function AdditionalContracts:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function AdditionalContracts:searchOtherMods()
	AdditionalContracts.otherMods.autoload = g_modIsLoaded["FS25_UniversalAutoload"] and FS25_UniversalAutoload ~= nil;
	AdditionalContracts.otherMods.rollerMission = g_modIsLoaded["FS25_RollerMission"] and _G["FS25_RollerMission"] ~= nil;		
end;

--guiUI--
function AdditionalContracts:initUISetting()
	if not AdditionalContracts.values.isInitUISetting then		
		AdditionalContracts.values.isInitUISetting = true;
		local uiSettings = UISettings.new();
		uiSettings:registerSettings();		
	end;
end;
--guiUI--

--hlUtils--
function AdditionalContracts:createIcons()
	local _, _ = g_currentMission.hlUtils.insertIcons( {xmlTagName="additionalcontracts.mapHotspots128", modDir=AdditionalContracts.modDir, iconFile="icons_additionalcontracts/icons.dds", xmlFile="icons_additionalcontracts/icons.xml", modName="AdditionalContracts", groupName="mapHotspots", fileFormat={128,1024,512}} );
end;
--hlUtils--

--hlHudSystem--
function AdditionalContracts:createHlSystemValues()
	if g_currentMission.hlUtils.modLoaded["FS25_MissionsDisplay"] ~= nil and g_currentMission.hlUtils.globalFunction["FS25_MissionsDisplay"].getModDir ~= nil then
		local modDir = g_currentMission.hlUtils.globalFunction["FS25_MissionsDisplay"].getModDir();
		local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="additionalcontracts.colorIcons32", modDir=modDir, iconFile="hlHudSystem/icons/colorIcons.dds", xmlModDir=AdditionalContracts.modDir, xmlFile="icons_additionalcontracts/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={32,128,256}} );
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="additionalcontracts.other1Icons32", modDir=modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlModDir=AdditionalContracts.modDir, xmlFile="icons_additionalcontracts/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={32,256,512}} );
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="additionalcontracts.otherIcons32", modDir=modDir, iconFile="hlHudSystem/icons/otherIcons.dds", xmlModDir=AdditionalContracts.modDir, xmlFile="icons_additionalcontracts/icons.xml", modName="Missions_Display", groupName="missions", fileFormat={32,256,512}} );
	end;
end;
--hlHudSystem--