ActiveMissionsTimeEvent = {};
local ActiveMissionsTimeEvent_mt = Class(ActiveMissionsTimeEvent, Event);

InitEventClass(ActiveMissionsTimeEvent, "ActiveMissionsTimeEvent");

function ActiveMissionsTimeEvent.emptyNew()
	local self = Event.new(ActiveMissionsTimeEvent_mt);
	self.className = "ActiveMissionsTimeEvent";
	return self;
end;

function ActiveMissionsTimeEvent.new(mission)
	local self = ActiveMissionsTimeEvent.emptyNew();
	self.mission = mission;	
	return self;
end;

function ActiveMissionsTimeEvent:writeStream(streamId, connection)
	--if not connection:getIsServer() then
		NetworkUtil.writeNodeObject(streamId, self.mission);		
		streamWriteInt32(streamId, self.mission.activeMissionId);
	--end;
end;

function ActiveMissionsTimeEvent:readStream(streamId, connection)
	--if connection:getIsServer() then
		self.mission = NetworkUtil.readNodeObject(streamId);		
		self.mission.activeMissionId = streamReadInt32(streamId);
	--end;

	self:run(connection);
end;

function ActiveMissionsTimeEvent:run(connection)
	if connection:getIsServer() then
		--print("####sprung ActiveMissionsTimeEvent.run, connection:getIsServer()")
		ActiveMissionsTime:setRunningEndDate(self.mission);	
		g_messageCenter:publish(ActiveMissionsTimeEvent, self.mission);
		return;
	else
		--print("####sprung ActiveMissionsTimeEvent.run, NOT connection:getIsServer()")
		--ActiveMissionsTime:setRunningEndDate(self.mission);
	end;
end

