ActiveMissionsTime = {};
ActiveMissionsTime.modDir = g_currentModDirectory;
source(ActiveMissionsTime.modDir.."ActiveMissionsTimeEvent.lua");

ActiveMissionsTime.metadata = {
	interface = "FS25 ...", --new ls25
	title = "Active Missions Time",
	notes = "Dieser Mod deaktivert die Missionszeit für alle aktiven Missionen.",
	author = "(by HappyLooser)",
	version = "1.0.0.1",	
	build = 2,	
	datum = "30.06.2025",
	update = "14.08.2025",	
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function ActiveMissionsTime:canDeleteActiveMissionTime(mission)	
	local canDeleteTime = {
		FS25_SupplyTransportContracts = false; --Mod not compatible (no security query whether times are nil)		 
	};
	if mission.canDeleteActiveMissionTime ~= nil then return mission:canDeleteActiveMissionTime();end; 
	if canDeleteTime[mission.customEnvironment] ~= nil then return canDeleteTime[mission.customEnvironment];end;
	return nil;
end;	

function ActiveMissionsTime:loadMap(name)
	print("---loading ".. tostring(ActiveMissionsTime.metadata.title).. " ".. tostring(ActiveMissionsTime.metadata.version).. "(#".. tostring(ActiveMissionsTime.metadata.build).. ") ".. tostring(ActiveMissionsTime.metadata.author).. "---")
	if getfenv(0)["FS25_MissionsTimes"] ~= nil and getfenv(0)["FS25_MissionsTimes"]["MissionsTimes"] ~= nil then
		Logging.info("Mod ".. tostring(ActiveMissionsTime.metadata.title).. " not active, not compatible with Missions Times Mod");
	else
		ActiveMissionsTime:abstractMissionStart();
	end;	
end; 

function ActiveMissionsTime:onStartMission()
	if ActiveMissionsTime:getDetiServer() then return;end;	
	if g_currentMission.hlUtils ~= nil then		
		ActiveMissionsTime.otherMods.missionsTimes = g_currentMission.hlUtils.modLoaded["FS25_MissionsTimes"] ~= nil;				
	end;
end;

---------------------------------------------------------------------------------------------
function ActiveMissionsTime:abstractMissionStart()	
	oldAbstractMissionStart = AbstractMission.start;
	AbstractMission.start = function(self, spawnVehicles)
		local isOkay, result = pcall(oldAbstractMissionStart, self, spawnVehicles)
		if isOkay and self ~= nil then			
			if g_currentMission.missionDynamicInfo.isMultiplayer then
				if (ActiveMissionsTime:getDetiServer() or ActiveMissionsTime:getHostOrSp()) then
					ActiveMissionsTime:setRunningEndDate(self);
					self:raiseActive();
					g_server:broadcastEvent(ActiveMissionsTimeEvent.new(self));
				end;
			else
				ActiveMissionsTime:setRunningEndDate(self);
			end;			
			return result;
		end;
	end;	
end;

function ActiveMissionsTime:setRunningEndDate(mission)	
	if mission ~= nil then		
		local canDeleteActiveMissionTime = true;
		if mission.customEnvironment ~= nil then canDeleteActiveMissionTime = ActiveMissionsTime:canDeleteActiveMissionTime(mission);end; --Mod compatible !		
		if mission.endDate ~= nil and (canDeleteActiveMissionTime == nil or canDeleteActiveMissionTime) then			
			mission.endDate = nil;			
		end;
	end;
end;
---------------------------------------------------------------------------------------------
addModEventListener(ActiveMissionsTime);

function ActiveMissionsTime:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function ActiveMissionsTime:getHostOrSp()	
	return (g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil) or (not g_currentMission.missionDynamicInfo.isMultiplayer); --only mp host player or single player
end;
